import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, convert_to_datetime, get_max, to_list, get_min_value, sort_by_values, get_first_n_rows, create_date_offset, filter_by_date, concatenate_objects, reset_index, rename_columns, bind_dataframe

# Load the dataset
atp_tennis = read_csv_file("atp_tennis.csv")

# Convert the 'Date' column to datetime format
atp_tennis['Date'] = convert_to_datetime(atp_tennis['Date'])

# Find the last date in the dataset
last_date = get_max(atp_tennis['Date'])

# Filter the dataset to only include matches from the last five years
five_years_ago = last_date - create_date_offset(years=5)
recent_matches = filter_by_date(atp_tennis, 'Date', five_years_ago)

concatenated_data = concatenate_objects(
    recent_matches[['Player_1', 'Rank_1']],
    rename_columns(recent_matches[['Player_2', 'Rank_2']], {'Player_2': 'Player_1', 'Rank_2': 'Rank_1'})
)
grouped_data = bind_dataframe(concatenated_data, 'Player_1')
min_values = get_min_value(grouped_data)
sorted_data = sort_by_values(min_values, 'Rank_1')
top_10_ranked_players = get_first_n_rows(sorted_data, 10)

# Convert the top 10 ranked players and their rankings to a Python list
top_10_ranked_players_list = to_list(reset_index(top_10_ranked_players, drop=False))

print(top_10_ranked_players_list)
pickle.dump(top_10_ranked_players_list,open("./ref_result/top_10_ranked_players_list.pkl","wb"))